/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ManagedObjectTreeEvent;
import com.ibm.hwmca.fw.managed.ManagedObjectTreeListener;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.tree.SimpleTreeNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManagedObjectTree
implements PropertyChangeListener,
Serializable {
    private static final String[] PARENT_OBJECT_PROPERTY_NAMES = new String[]{"Children", "Root"};
    private transient ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private transient Object treeLock = new Object();
    private SimpleTreeNode root;
    private HashMap addedObjectIds = new HashMap();
    private HashMap orphinObjectIds = new HashMap();
    private transient ArrayList listeners;
    private Object userData;
    private static final String TRACE_MASKT = "HMOTREET";
    private static final String TRACE_MASKF = "HMOTREEF";
    private static final String TRACE_MASKD = "HMOTREED";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Group;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaParentObject;

    ManagedObjectTree(ObjectId momObjectId, ManagedObjectTreeListener listener) {
        this(momObjectId, null, listener);
    }

    ManagedObjectTree(ObjectId momObjectId, Set objectIds) {
        this(momObjectId, objectIds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedObjectTree(ObjectId momObjectId, Set objectIds, ManagedObjectTreeListener listener) {
        Trace.trace(TRACE_MASKT, "-> ManagedObjectTree.ManagedObjectTree()");
        this.root = new SimpleTreeNode(momObjectId);
        if (objectIds != null) {
            Object object = this.treeLock;
            synchronized (object) {
                this.add(objectIds);
            }
        }
        if (listener != null) {
            this.addManagedObjectTreeListener(listener);
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObjectTree.ManagedObjectTree()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId[] getUniqueObjectIds() {
        Trace.trace(TRACE_MASKT, "<> ManagedObjectTree.getUniqueObjectIds()");
        Set uniqueIds = null;
        Object object = this.treeLock;
        synchronized (object) {
            uniqueIds = this.root.getUniqueUserObjects();
        }
        return uniqueIds.toArray(new ObjectId[uniqueIds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId[] getUniqueObjectIds(boolean returnOrphins) {
        Trace.trace(TRACE_MASKT, "<> ManagedObjectTree.getUniqueObjectIds(boolean)");
        Set uniqueIds = null;
        Object object = this.treeLock;
        synchronized (object) {
            uniqueIds = this.root.getUniqueUserObjects();
            Iterator iterator = this.orphinObjectIds.keySet().iterator();
            while (iterator.hasNext()) {
                ObjectId objectId = (ObjectId)iterator.next();
                if (uniqueIds.contains(objectId)) continue;
                uniqueIds.add(objectId);
            }
        }
        return uniqueIds.toArray(new ObjectId[uniqueIds.size()]);
    }

    public void addManagedObjectTreeListener(ManagedObjectTreeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public SimpleTreeNode getRoot() {
        return this.root;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }

    public boolean removeConsoleObjects() {
        boolean result = false;
        ObjectId id = new ObjectId("com.ibm.hwmca.fw.managed", "TaskGroup");
        id.setKeyProperty("Name", "base.taskgroup.consact");
        SimpleTreeNode consoleTaskNode = this.root.getFirstNodeForUserObject(id);
        if (consoleTaskNode != null) {
            result = consoleTaskNode.getParent().remove(consoleTaskNode);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId[] getRootObjectIds() {
        Trace.trace(TRACE_MASKT, "-> ManagedObjectTree.getRootObjectIds()");
        ObjectId[] ids = null;
        Object object = this.treeLock;
        synchronized (object) {
            List children = this.root.getChildren();
            int numChildren = children.size();
            if (numChildren > 0) {
                ids = new ObjectId[numChildren];
                int i = 0;
                while (i < numChildren) {
                    ids[i] = (ObjectId)((SimpleTreeNode)children.get(i)).getUserObject();
                    ++i;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObjectTree.getRootObjectIds()");
        return ids;
    }

    private List add(Collection objectIds) {
        Trace.trace(TRACE_MASKT, "-> ManagedObjectTree.add()");
        HashMap<ObjectId, Map> savedObjectIds = new HashMap<ObjectId, Map>();
        ArrayList<SimpleTreeNode> addedNodes = new ArrayList<SimpleTreeNode>();
        Iterator iterator = objectIds.iterator();
        while (iterator.hasNext()) {
            Boolean rootObject;
            Map properties;
            boolean parentObject;
            ObjectId id = (ObjectId)iterator.next();
            if (id.isInstanceOf(class$com$ibm$hwmca$fw$managed$Group == null ? ManagedObjectTree.class$("com.ibm.hwmca.fw.managed.Group") : class$com$ibm$hwmca$fw$managed$Group) || id.isInstanceOf(class$com$ibm$hwmca$fw$managed$HwmcaParentObject == null ? ManagedObjectTree.class$("com.ibm.hwmca.fw.managed.HwmcaParentObject") : class$com$ibm$hwmca$fw$managed$HwmcaParentObject)) {
                parentObject = true;
                properties = this.mom.getProperties(id, PARENT_OBJECT_PROPERTY_NAMES);
                rootObject = (Boolean)properties.get("Root");
            } else {
                parentObject = false;
                properties = null;
                rootObject = null;
            }
            if (rootObject != null && rootObject.booleanValue()) {
                SimpleTreeNode childNode = new SimpleTreeNode(id);
                this.root.add(childNode);
                this.addedObjectIds.put(id, properties);
                addedNodes.add(childNode);
                continue;
            }
            savedObjectIds.put(id, properties);
        }
        this.addNonRootObjectIds(savedObjectIds, addedNodes);
        this.addNonRootObjectIds(this.orphinObjectIds, addedNodes);
        if (savedObjectIds.size() > 0) {
            this.orphinObjectIds.putAll(savedObjectIds);
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObjectTree.add()");
        return addedNodes;
    }

    private void addNonRootObjectIds(HashMap savedObjectIds, List addedNodes) {
        boolean nodeAdded;
        Trace.trace(TRACE_MASKT, "-> ManagedObjectTree.addNonRootObjectIds()");
        do {
            nodeAdded = false;
            HashMap cloned = (HashMap)savedObjectIds.clone();
            Iterator iterator = cloned.keySet().iterator();
            while (iterator.hasNext()) {
                ObjectId id = (ObjectId)iterator.next();
                ArrayList keys = new ArrayList(this.addedObjectIds.keySet());
                Iterator addedIds = keys.iterator();
                while (addedIds.hasNext()) {
                    List children;
                    ObjectId parentId = (ObjectId)addedIds.next();
                    Map addedProperties = (Map)this.addedObjectIds.get(parentId);
                    if (addedProperties == null || (children = (List)addedProperties.get("Children")) == null || !children.contains(id)) continue;
                    Map properties = null;
                    if (id.isInstanceOf(class$com$ibm$hwmca$fw$managed$Group == null ? ManagedObjectTree.class$("com.ibm.hwmca.fw.managed.Group") : class$com$ibm$hwmca$fw$managed$Group) || id.isInstanceOf(class$com$ibm$hwmca$fw$managed$HwmcaParentObject == null ? ManagedObjectTree.class$("com.ibm.hwmca.fw.managed.HwmcaParentObject") : class$com$ibm$hwmca$fw$managed$HwmcaParentObject)) {
                        properties = this.mom.getProperties(id, PARENT_OBJECT_PROPERTY_NAMES);
                    }
                    List parents = this.root.getNodesForUserObject(parentId);
                    Iterator parentNodes = parents.iterator();
                    while (parentNodes.hasNext()) {
                        SimpleTreeNode parentNode = (SimpleTreeNode)parentNodes.next();
                        SimpleTreeNode childNode = new SimpleTreeNode(id);
                        parentNode.add(childNode);
                        this.addedObjectIds.put(id, properties);
                        addedNodes.add(childNode);
                        if (!id.isInstanceOf(class$com$ibm$hwmca$fw$managed$Group == null ? ManagedObjectTree.class$("com.ibm.hwmca.fw.managed.Group") : class$com$ibm$hwmca$fw$managed$Group) && !id.isInstanceOf(class$com$ibm$hwmca$fw$managed$HwmcaParentObject == null ? ManagedObjectTree.class$("com.ibm.hwmca.fw.managed.HwmcaParentObject") : class$com$ibm$hwmca$fw$managed$HwmcaParentObject)) continue;
                        List newChildren = (List)properties.get("Children");
                        Iterator iterator2 = newChildren.iterator();
                        while (iterator2.hasNext()) {
                            ObjectId newChild = (ObjectId)iterator2.next();
                            if (!this.addedObjectIds.containsKey(newChild)) continue;
                            SimpleTreeNode grandChildNode = new SimpleTreeNode(id);
                            childNode.add(grandChildNode);
                            addedNodes.add(grandChildNode);
                        }
                    }
                    savedObjectIds.remove(id);
                    nodeAdded = true;
                }
            }
        } while (nodeAdded);
        Trace.trace(TRACE_MASKT, "<- ManagedObjectTree.addNonRootObjectIds()");
    }

    private List remove(ObjectId[] objectIds) {
        Trace.trace(TRACE_MASKT, "-> ManagedObjectTree.remove()");
        ArrayList removedNodes = new ArrayList();
        int i = 0;
        while (i < objectIds.length) {
            removedNodes.addAll(this.root.getNodesForUserObject(objectIds[i]));
            this.root.removeNodesForUserObject(objectIds[i]);
            this.addedObjectIds.remove(objectIds[i]);
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObjectTree.remove()");
        return removedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> ManagedObjectTree.propertyChange()");
        int eventType = 2;
        ObjectId[] values = (ObjectId[])evt.getOldValue();
        if (values == null) {
            eventType = 1;
            values = (ObjectId[])evt.getNewValue();
        }
        List changes = null;
        Object object = this.treeLock;
        synchronized (object) {
            if (eventType == 1) {
                ArrayList<ObjectId> list = new ArrayList<ObjectId>(values.length);
                int i = 0;
                while (i < values.length) {
                    list.add(values[i]);
                    ++i;
                }
                changes = this.add(list);
            } else {
                changes = this.remove(values);
            }
        }
        if (changes != null && this.listeners != null) {
            ManagedObjectTreeEvent treeEvent = new ManagedObjectTreeEvent(this, changes, eventType);
            Iterator iterator = ((List)this.listeners.clone()).iterator();
            while (iterator.hasNext()) {
                ManagedObjectTreeListener listener = (ManagedObjectTreeListener)iterator.next();
                if (eventType == 1) {
                    listener.treeNodesAdded(treeEvent);
                    continue;
                }
                listener.treeNodesRemoved(treeEvent);
            }
        }
        Trace.trace(TRACE_MASKT, "<- ManagedObjectTree.propertyChange()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

